'use client';

import Image from 'next/image';
import Link from 'next/link';
import { useLanguage } from '@/contexts/language-context';
import { PlaceHolderImages } from '@/lib/placeholder-images';
import { motion } from 'framer-motion';
import { ArrowRight, Zap, CheckCircle } from 'lucide-react';
import { Button } from './ui/button';

export default function NoorEnergySection() {
  const { content } = useLanguage();
  const { noorEnergy } = content;
  const image = PlaceHolderImages.find((img) => img.id === 'noor-energy-about');

  return (
    <section className="py-20 sm:py-24 bg-background">
      <div className="container mx-auto grid grid-cols-1 items-center gap-12 lg:grid-cols-2">
        <motion.div
          className="relative"
          initial={{ opacity: 0, x: -30 }}
          whileInView={{ opacity: 1, x: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.7 }}
        >
          <div className="absolute -inset-2 bg-gradient-to-br from-green-500 via-teal-500 to-cyan-500 rounded-3xl blur-xl opacity-20"></div>
          {image && (
            <div className="relative overflow-hidden shadow-2xl rounded-3xl border-2 border-white/50 bg-white p-4">
              <div className="aspect-w-16 aspect-h-10 h-[450px] relative">
                <Image
                  src={image.imageUrl}
                  alt={image.description}
                  fill
                  className="object-contain"
                  data-ai-hint={image.imageHint}
                />
                <div className="absolute inset-0 bg-gradient-to-t from-black/5 to-transparent"></div>
              </div>
            </div>
          )}
        </motion.div>
        <motion.div
          initial={{ opacity: 0, x: 30 }}
          whileInView={{ opacity: 1, x: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.7, delay: 0.2 }}
        >
          <div className="inline-flex items-center gap-2 mb-6 px-4 py-2 rounded-full bg-gradient-to-r from-green-500/10 via-teal-500/10 to-green-500/10 border border-green-500/20">
            <Zap className="w-5 h-5 text-green-600" />
            <span className="text-sm font-bold text-primary">
              NOOR RENEWABLE ENERGY
            </span>
          </div>
          <h2 className="font-headline text-3xl font-bold tracking-tight bg-gradient-to-r from-green-700 via-primary to-green-700 bg-clip-text text-transparent sm:text-4xl mb-4">
            {noorEnergy.title}
          </h2>
          <div className="h-1 w-24 bg-gradient-to-r from-green-500 to-teal-500 rounded-full mb-8"></div>
          <p className="text-base leading-7 text-muted-foreground">
            {noorEnergy.text}
          </p>
          <Button asChild className="mt-8 group" size="lg" >
            <Link href="https://www.noorenergy-iq.com/" target="_blank" rel="noopener noreferrer">
              {noorEnergy.websiteButton}
              <ArrowRight className="h-5 w-5 transition-transform duration-300 group-hover:translate-x-1" />
            </Link>
          </Button>
        </motion.div>
      </div>
    </section>
  );
}
